#!/bin/bash
exp_id=$1
num_shadow=$2

DATA_PATH="datasets"
BUFFER_PATH="buffer/datm"

python src/dd/buffer_datm.py \
    --dataset CIFAR10 \
    --model ConvNet \
    --train_epochs 100 \
    --num_experts 100 \
    --zca \
    --buffer_path $BUFFER_PATH \
    --data_path $DATA_PATH \
    --rho_max 0.01 \
    --rho_min 0.01 \
    --alpha 0.3 \
    --lr_teacher 0.01 \
    --mom 0. \
    --batch_train 256 \
    --exp_id $exp_id \
    --num_shadow $num_shadow \
    --num_canaries 500 > logs/datm/datm_buffer_exp_$exp_id.log
